// $Id: CVstEffect.cpp,v 1.6 2007/02/27 19:47:38 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
 */

#include "CVstEffect.hpp"
#include "CVst.hpp"
using Exponent::Vst::CVstEffect;
using Exponent::Vst::CVst;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CVstEffect, CCountedObject);

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
CVstEffect::CVstEffect(audioMasterCallback audioMaster, const VstInt32 numberOfParameters, const VstInt32 numberOfPresets) 
#else
CVstEffect::CVstEffect(audioMasterCallback audioMaster, const long numberOfParameters, const long numberOfPresets) 
#endif
		  : AudioEffectX(audioMaster, numberOfPresets, numberOfParameters), m_criticalSection(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CVstEffect);


	//--------------------------------
	// HOST SPECIFIC
	//--------------------------------

	m_hostCanDo.initialise();											// Default all host can do stuff
	m_hostCanDo.setFromAudioEffectX(this);								// Get the host information for this instanciation
	m_processInfo.intialise();											// Default all the process info
	m_processInfo.m_blockSize  = this->getBlockSize();					// Setup all the variables to sensible defaults
	m_processInfo.m_sampleRate = (double)this->getSampleRate();			// Setup all the variables to sensible defaults
	m_vstTempo.initialiseFromAudioEffectX(this);						// Setup the time info

	//--------------------------------
	// MIDI SPECIFIC
	//--------------------------------

	// Create our midi control array (by default all of our controls are unbound)
	for (long i = 0; i < CMidi::CMIDI_MAX_CC; i++)
	{
		m_midiControllers.addElement(new TPointerCollection<CLong>);
	}

	// Initi the midi channel for the event list
	m_midiEventList.setMidiChannel(0);

	//--------------------------------
	// STATE SPECIFIC
	//--------------------------------

	// Create and reference the ciritical section
	m_criticalSection = new CCriticalSection();
	m_criticalSection->referenced();
}

//	===========================================================================
CVstEffect::~CVstEffect()
{
	EXPONENT_CLASS_DESTRUCTION(CVstEffect);
	FORGET_COUNTED_OBJECT(m_criticalSection);
}

//	===========================================================================
void CVstEffect::resume()
{
	// Call base class implementation
	AudioEffectX::resume();

	// We want midi events
	#ifndef VST_2_4_EXTENSIONS	
	this->wantEvents();
	#endif
}

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
void CVstEffect::process(float **input, float **output, VstInt32 numberOfSamples)
#else
void CVstEffect::process(float **input, float **output, long numberOfSamples)
#endif
{
	m_midiEventList.clearEvents();
}

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
void CVstEffect::processReplacing(float **input, float **output, VstInt32 numberOfSamples)
#else
void CVstEffect::processReplacing(float **input, float **output, long numberOfSamples)
#endif
{
	m_midiEventList.clearEvents();
}

#ifdef VST_2_4_EXTENSIONS
//	===========================================================================
void CVstEffect::processDoubleReplacing(double **inputs, double ** outputs, VstInt32 numberOfSamples)
{
	m_midiEventList.clearEvents();
}
#endif

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
VstInt32 CVstEffect::processEvents(VstEvents *events)
#else
long CVstEffect::processEvents(VstEvents *events)
#endif
{
	// Add the vst events
	m_midiEventList.addFromVSTEvent(events);

	// we want more events next time :)
	#ifdef VST_2_4_EXTENSIONS
	return (VstInt32)CVst::CVST_WANT_MORE_EVENTS;
	#else
	return CVst::CVST_WANT_MORE_EVENTS;
	#endif
}

//	===========================================================================
bool CVstEffect::getEffectName(char* name)
{
	if (name)
	{
		CApplication::getApplicationName().getString(name, 24);
		return true;
	}
	return false;
}

//	===========================================================================
bool CVstEffect::getVendorString(char* text)
{
	if (text)
	{
		CApplication::getApplicationDeveloper().getString(text, 24);
		return true;
	}
	return false;
}

//	===========================================================================
bool CVstEffect::getProductString(char* text)
{
	if (text)
	{
		CApplication::getApplicationDescription().getString(text, 24);
		return true;
	}
	return false;
}

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
void CVstEffect::setBlockSize(VstInt32 blockSize)
#else
void CVstEffect::setBlockSize(long blockSize)
#endif
{
	// Call the base class
	AudioEffectX::setBlockSize(blockSize);

	// Guard against recomputing every so often if the host sends the same rate
	// again and agin. Not sure if this is a rumour, but easy to protect against
	if (m_processInfo.m_blockSize != blockSize)
	{
		// Size has changed
		m_processInfo.m_blockSizeChanged = true;

		// Store the block size
		m_processInfo.m_blockSize = blockSize;
	}

}

//	===========================================================================
void CVstEffect::setSampleRate(float rate)
{
	// Call the base class
	AudioEffectX::setSampleRate(rate);

	// Guard against recomputing every so often if the host sends the same rate
	// again and agin. Not sure if this is a rumour, but easy to protect against
	if (m_processInfo.m_sampleRate != rate)
	{
		// Size has changed
		m_processInfo.m_sampleRateChanged = true;

		// Store the block size
		m_processInfo.m_sampleRate = rate;
	}
}

//	===========================================================================
void CVstEffect::setMidiChannel(const long channel)
{
	m_midiEventList.setMidiChannel(channel);
}